Scriptname RF:TravelKiller Extends Quest

Actor PlayerRef

MiscObject Property TheContraband Auto Mandatory Const

Keyword Property LocTypeSENotAllowed Mandatory Const Auto
GlobalVariable Property _RF_Sys_AllowTravel Mandatory Const Auto

bool Running = true

Function Limit(bool abLimit = true)
    If !abLimit
        PlayerRef.RemoveItem(TheContraband, 999, true)
    Else
        PlayerRef.AddItem(TheContraband, 1, true)
    EndIF
EndFunction

Event OnQuestInit()
    StartTimer(3)
EndEvent

Event OnTimer(int aiTimerID)
    PlayerRef = Game.GetPlayer()
    RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
    Limit()
EndEvent

Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
    if _RF_Sys_AllowTravel.GetValue() != 1
        Running = True
        If PlayerRef.IsInSpace()
            If akNewLoc.HasKeyword(LocTypeSENotAllowed)
                Limit(0)
            Else
                Limit()
            EndIf
        EndIf
    Else
        If Running
            Debug.Notification("Travel suppressor disabled")
        EndIf
        Limit(0)
        Running = False
    EndIF
EndEvent